/******************************************************************************
 * The contents of this file are subject to the   Compiere License  Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * You may obtain a copy of the License at http://www.compiere.org/license.html
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is                  Compiere  ERP & CRM  Business Solution
 * The Initial Developer of the Original Code is Jorg Janke  and ComPiere, Inc.
 *
 * Copyright (C) 2005 Robert KLEIN. robeklein@gmail.com * 
 * Contributor(s): ______________________________________.
 *****************************************************************************/
package org.compiere.CopyAccounts;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.model.MSequence;
import org.compiere.model.X_C_Copy_Accounts;
import org.compiere.process.*;


/**
 *	Convert AD to XML
 *	
 *  @author Robert Klein
 *  @version $Id: CopyRole.java,v 1.0$
 *  
 */

public class CopyAccount extends SvrProcess
{
	private int m_AD_Role_ID_From = 0;
	private int m_AD_Role_ID_To = 0;
	private int m_AD_Client_ID = 0;	
	private int m_AD_Org_ID = 0;
	String V_COMBINATION_VALUE = null;
	String V_COMBINATION_NAME = null;
	StringBuffer sqlB = null;
	StringBuffer sqlC = null;
	private Object[] m_newValues = null;
	public int p_CopyAcct_ID = 0;
	
	/**
	 *  Prepare - e.g., get Parameters.
	 */
	protected void prepare()
	{
		
		ProcessInfoParameter[] para = getParameter();
		p_CopyAcct_ID = getRecord_ID();
		for (int i = 0; i < para.length; i++)
		{
		String name = para[i].getParameterName();
		if (para[i].getParameter() == null)
				;
			else if (name.equals("AD_Role_ID") && i == 0)
				m_AD_Role_ID_From = para[i].getParameterAsInt();
			else if (name.equals("AD_Role_ID")&& i == 1)
				m_AD_Role_ID_To = para[i].getParameterAsInt();
			else if (name.equals("AD_Client_ID"))
				m_AD_Client_ID = para[i].getParameterAsInt();
			else if (name.equals("AD_Org_ID"))
				m_AD_Org_ID = para[i].getParameterAsInt();
		}		
	}	//	prepare
	
	/**
	 * 	Start the copy
	 *	@return info
	 *	@throws Exception
	 */
	protected String doIt() throws java.lang.Exception
	{	
		
		X_C_Copy_Accounts CopyAccount = new X_C_Copy_Accounts(
				getCtx(),p_CopyAcct_ID, null);
		
		String sql = "SELECT AD_ORG.AD_ORG_ID, AD_ORG.VALUE, AD_ORG.NAME , "
			+"C_COPY_ACCOUNTS.AD_ORGTRX_ID_TO, C_COPY_ACCOUNTS.AD_ORGTRX_ID_FROM "
			+"FROM COMPIERE.AD_ORG, COMPIERE.C_COPY_ACCOUNTS "
			+" WHERE AD_ORG.AD_ORG_ID >= C_COPY_ACCOUNTS.AD_ORGTRX_ID_FROM "
			+" AND AD_ORG.AD_ORG_ID <= C_COPY_ACCOUNTS.AD_ORGTRX_ID_TO";
		PreparedStatement pstmt = null;
		pstmt = DB.prepareStatement (sql);
		
		try {			
			ResultSet rs = pstmt.executeQuery();		
			while (rs.next())
			{							
					
					sqlB = new StringBuffer ("SELECT  C_ELEMENTVALUE.C_ELEMENTVALUE_ID,"
							+" C_COPY_ACCOUNTS.ACCOUNT_ID_FROM, C_COPY_ACCOUNTS.ACCOUNT_ID_TO,"
							+" C_COPY_ACCOUNTS.AD_CLIENT_ID,  C_COPY_ACCOUNTS.AD_ORG_ID,"
							+" C_COPY_ACCOUNTS.ISACTIVE, C_COPY_ACCOUNTS.CREATED,"
							+" C_COPY_ACCOUNTS.CREATEDBY, C_COPY_ACCOUNTS.UPDATED,"
							+" C_COPY_ACCOUNTS.UPDATEDBY, C_ELEMENTVALUE.VALUE,"
							+" C_ELEMENTVALUE.NAME, C_COPY_ACCOUNTS.C_ACCTSCHEMA_ID,"
							+" C_COPY_ACCOUNTS.M_PRODUCT_ID_FROM, C_COPY_ACCOUNTS.C_BPARTNER_ID_FROM,"
							+" C_COPY_ACCOUNTS.AD_ORGTRX_ID_FROM, C_COPY_ACCOUNTS.C_SALESREGION_ID_FROM,"
							+" C_COPY_ACCOUNTS.C_PROJECT_ID_FROM, C_COPY_ACCOUNTS.C_CAMPAIGN_ID_FROM," 
							+" C_COPY_ACCOUNTS.USER1_ID_FROM, C_COPY_ACCOUNTS.USER2_ID_FROM"
							+" FROM COMPIERE.C_ELEMENTVALUE, COMPIERE.C_COPY_ACCOUNTS"
							+" WHERE C_ELEMENTVALUE.VALUE >= C_COPY_ACCOUNTS.ACCOUNT_ID_FROM "
							+" AND C_ELEMENTVALUE.VALUE <= C_COPY_ACCOUNTS.ACCOUNT_ID_TO"
							+" AND C_COPY_ACCOUNTS.C_COPY_ACCOUNTS_ID = " + p_CopyAcct_ID);
					
					PreparedStatement pstmt1 = null;
					pstmt1 = DB.prepareStatement (sqlB.toString());
					log.info(sqlB.toString());
					try {			
						ResultSet rs1 = pstmt1.executeQuery();		
						while (rs1.next())
						{
						  V_COMBINATION_VALUE = rs.getString("VALUE") + "-" + rs1.getString("VALUE");
						  V_COMBINATION_NAME =  rs.getString("NAME") + "-" + rs1.getString("NAME");

						  if (rs1.getString("M_PRODUCT_ID_FROM") == null){ 
						     V_COMBINATION_VALUE = V_COMBINATION_VALUE + "-" + "_";
						     V_COMBINATION_NAME = V_COMBINATION_NAME + "-" + "_";
						  }
						  else{
							  sqlC = new StringBuffer ("SELECT M_PRODUCT.VALUE"
									  + " FROM COMPIERE.M_PRODUCT"
									  + " WHERE M_PRODUCT.M_PRODUCT_ID = ?");
							
							  String v_value = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("M_PRODUCT_ID_FROM"));
							  
							  sqlC = new StringBuffer ("SELECT M_PRODUCT.NAME"
									  + " FROM COMPIERE.M_PRODUCT"
									  + " WHERE M_PRODUCT.M_PRODUCT_ID = ?");
							
							  String v_name = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("M_PRODUCT_ID_FROM"));							
						     
						     V_COMBINATION_VALUE = V_COMBINATION_VALUE + '-' + v_value;
						     V_COMBINATION_NAME = V_COMBINATION_NAME + '-' + v_name;
						  }
						  
						  if (rs1.getString("C_BPARTNER_ID_FROM") == null){ 
							     V_COMBINATION_VALUE = V_COMBINATION_VALUE + "-" + "_";
							     V_COMBINATION_NAME = V_COMBINATION_NAME + "-" + "_";
							  }
							  else{
								  sqlC = new StringBuffer ("SELECT C_BPARTNER.VALUE"
										  + " FROM COMPIERE.C_BPARTNER"
										  + " WHERE C_BPARTNER.C_BPARTNER_ID = ?");
								
								  String v_value = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("C_BPARTNER_ID_FROM"));
								  
								  sqlC = new StringBuffer ("SELECT C_BPARTNER.NAME"
										  + " FROM COMPIERE.C_BPARTNER"
										  + " WHERE C_BPARTNER.C_BPARTNER_ID = ?");
								
								  String v_name = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("C_BPARTNER_ID_FROM"));							
							     
							     V_COMBINATION_VALUE = V_COMBINATION_VALUE + '-' + v_value;
							     V_COMBINATION_NAME = V_COMBINATION_NAME + '-' + v_name;
							  }						  
						  
						  if (rs1.getString("C_PROJECT_ID_FROM") == null){ 
							     V_COMBINATION_VALUE = V_COMBINATION_VALUE + "-" + "_";
							     V_COMBINATION_NAME = V_COMBINATION_NAME + "-" + "_";
							  }
							  else{
								  sqlC = new StringBuffer ("SELECT C_PROJECT.VALUE"
										  + " FROM COMPIERE.C_PROJECT"
										  + " WHERE C_PROJECT.C_PROJECT_ID = ?");
								
								  String v_value = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("C_PROJECT_ID_FROM"));
								  
								  sqlC = new StringBuffer ("SELECT C_PROJECT.NAME"
										  + " FROM COMPIERE.C_PROJECT"
										  + " WHERE C_PROJECT.C_PROJECT_ID = ?");
								
								  String v_name = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("C_PROJECT_ID_FROM"));							
							     
							     V_COMBINATION_VALUE = V_COMBINATION_VALUE + '-' + v_value;
							     V_COMBINATION_NAME = V_COMBINATION_NAME + '-' + v_name;
							  }
						    
						  if (rs1.getString("C_CAMPAIGN_ID_FROM") == null){ 
							     V_COMBINATION_VALUE = V_COMBINATION_VALUE + "-" + "_";
							     V_COMBINATION_NAME = V_COMBINATION_NAME + "-" + "_";
							  }
							  else{
								  sqlC = new StringBuffer ("SELECT C_CAMPAIGN.VALUE"
										  + " FROM COMPIERE.C_CAMPAIGN"
										  + " WHERE C_CAMPAIGN.C_CAMPAIGN_ID = ?");
								
								  String v_value = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("C_CAMPAIGN_ID_FROM"));
								  log.info(""+CopyAccount.getC_Campaign_Id_From());
								  
								  sqlC = new StringBuffer ("SELECT C_CAMPAIGN.NAME"
										  + " FROM COMPIERE.C_CAMPAIGN"
										  + " WHERE C_CAMPAIGN.C_CAMPAIGN_ID = ?");
								
								  String v_name = DB.getSQLValueString(null,sqlC.toString(),rs1.getInt("C_CAMPAIGN_ID_FROM"));							
							     
							     V_COMBINATION_VALUE = V_COMBINATION_VALUE + '-' + v_value;
							     V_COMBINATION_NAME = V_COMBINATION_NAME + '-' + v_name;
							  }
						  
						  sqlB = new StringBuffer ("SELECT count(*) FROM C_ValidCombination "
									+ "WHERE Combination = '"+V_COMBINATION_VALUE+"'");
									
						
						int count = DB.getSQLValue(null,sqlB.toString());
						
						if (count==0){							
							
							
							int v_C_ValidID = MSequence.getNextID (Env.getAD_Client_ID(Env.getCtx()), "C_ValidCombination", null);
							
							sqlB = new StringBuffer ("INSERT into COMPIERE.C_VALIDCOMBINATION "
								+ "(C_VALIDCOMBINATION_ID,AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATEDBY, "
								+ "UPDATEDBY, COMBINATION, DESCRIPTION, "
								+ "ISFULLYQUALIFIED, C_ACCTSCHEMA_ID, ACCOUNT_ID, M_PRODUCT_ID, "
								+ "C_BPARTNER_ID, C_SALESREGION_ID, C_PROJECT_ID, C_CAMPAIGN_ID, "
								+ " USER1_ID, USER2_ID) "
								+	"VALUES(" 
								+	" "+ v_C_ValidID
								+	", "+ Env.getAD_Client_ID(Env.getCtx())
								+	", "+ rs.getInt("AD_ORG_ID")
								+	", "+ "'Y'"
				    			+	", "+ Env.getAD_User_ID(Env.getCtx())
				    			+	", "+ Env.getAD_User_ID(Env.getCtx())
				    			+	", '"+ V_COMBINATION_VALUE
				    			+	"', '"+ V_COMBINATION_NAME
				    			+	"', "+ "'Y'"
				    			+	", "+ rs1.getObject("C_ACCTSCHEMA_ID")
				    			+	", "+ rs1.getObject("C_ELEMENTVALUE_ID")
				    			+	", "+ rs1.getObject("M_PRODUCT_ID_FROM")
				    			+	", "+ rs1.getObject("C_BPARTNER_ID_FROM")
				    			+	", "+ rs1.getObject("C_SALESREGION_ID_FROM")
				    			+	", "+ rs1.getObject("C_PROJECT_ID_FROM")
				    			+	", "+ rs1.getObject("C_CAMPAIGN_ID_FROM")
				    			+	", "+ rs1.getObject("USER1_ID_FROM")
				    			+	", "+ rs1.getObject("USER2_ID_FROM")+")");
							
							int no = DB.executeUpdate (sqlB.toString());
						
						}
						  }
					
					rs1.close();
					pstmt1.close();
					pstmt1 = null;
					
					}
				
					catch (Exception e)	{
						log.log(Level.SEVERE,"Create Valid Account Combinations", e);
				}
					
					sqlB = new StringBuffer ("UPDATE C_COPY_ACCOUNTS "
							+ "SET IsActive = 'N' "
							+ "WHERE C_Copy_Accounts_ID = " + p_CopyAcct_ID);		
					int no = DB.executeUpdate (sqlB.toString());
			}
					
			
			rs.close();
			pstmt.close();
			pstmt = null;			
		}	
		
			catch (Exception e)	{
				log.log(Level.SEVERE,"Create Valid Account Combinations", e);
			}
			finally
				{
					try
					{
						if (pstmt != null)
							pstmt.close ();
					}
					catch (Exception e)
					{}
					pstmt = null;
				}		return "";
	}	//	doIt
			}	//	CopyValidAccounts
